/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.command.dml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.h14199.command.Parser;
import org.h14199.command.dml.Optimizer;
import org.h14199.command.dml.Query;
import org.h14199.command.dml.SelectGroups;
import org.h14199.command.dml.SelectListColumnResolver;
import org.h14199.command.dml.SelectOrderBy;
import org.h14199.engine.Database;
import org.h14199.engine.Session;
import org.h14199.expression.Alias;
import org.h14199.expression.Expression;
import org.h14199.expression.ExpressionColumn;
import org.h14199.expression.ExpressionVisitor;
import org.h14199.expression.Parameter;
import org.h14199.expression.Wildcard;
import org.h14199.expression.analysis.Window;
import org.h14199.expression.condition.Comparison;
import org.h14199.expression.condition.ConditionAndOr;
import org.h14199.index.Cursor;
import org.h14199.index.Index;
import org.h14199.index.IndexType;
import org.h14199.index.ViewIndex;
import org.h14199.message.DbException;
import org.h14199.result.LazyResult;
import org.h14199.result.LocalResult;
import org.h14199.result.ResultInterface;
import org.h14199.result.ResultTarget;
import org.h14199.result.Row;
import org.h14199.result.SearchRow;
import org.h14199.result.SortOrder;
import org.h14199.table.Column;
import org.h14199.table.ColumnResolver;
import org.h14199.table.IndexColumn;
import org.h14199.table.JoinBatch;
import org.h14199.table.Table;
import org.h14199.table.TableFilter;
import org.h14199.table.TableType;
import org.h14199.table.TableView;
import org.h14199.util.ColumnNamer;
import org.h14199.util.StringUtils;
import org.h14199.util.Utils;
import org.h14199.value.Value;
import org.h14199.value.ValueNull;
import org.h14199.value.ValueRow;

public class Select
extends Query {
    TableFilter topTableFilter;
    private final ArrayList<TableFilter> filters = Utils.newSmallArrayList();
    private final ArrayList<TableFilter> topFilters = Utils.newSmallArrayList();
    private Select parentSelect;
    private Expression condition;
    private Expression having;
    private Expression qualify;
    int visibleColumnCount;
    private Expression[] distinctExpressions;
    private int[] distinctIndexes;
    private int distinctColumnCount;
    private ArrayList<Expression> group;
    int[] groupIndex;
    boolean[] groupByExpression;
    SelectGroups groupData;
    private int havingIndex;
    private int qualifyIndex;
    private int[] groupByCopies;
    boolean isGroupQuery;
    private boolean isGroupSortedQuery;
    private boolean isWindowQuery;
    private boolean isForUpdate;
    private boolean isForUpdateMvcc;
    private double cost;
    private boolean isQuickAggregateQuery;
    private boolean isDistinctQuery;
    private boolean isPrepared;
    private boolean checkInit;
    private boolean sortUsingIndex;
    private boolean isGroupWindowStage2;
    private HashMap<String, Window> windows;

    public Select(Session session, Select select) {
        super(session);
        this.parentSelect = select;
    }

    @Override
    public boolean isUnion() {
        return false;
    }

    public void addTableFilter(TableFilter tableFilter, boolean bl) {
        this.filters.add(tableFilter);
        if (bl) {
            this.topFilters.add(tableFilter);
        }
    }

    public ArrayList<TableFilter> getTopFilters() {
        return this.topFilters;
    }

    public void setExpressions(ArrayList<Expression> arrayList) {
        this.expressions = arrayList;
    }

    public void setWildcard() {
        this.expressions = new ArrayList(1);
        this.expressions.add(new Wildcard(null, null));
    }

    public void setGroupQuery() {
        this.isGroupQuery = true;
    }

    public void setWindowQuery() {
        this.isWindowQuery = true;
    }

    public void setGroupBy(ArrayList<Expression> arrayList) {
        this.group = arrayList;
    }

    public ArrayList<Expression> getGroupBy() {
        return this.group;
    }

    public SelectGroups getGroupDataIfCurrent(boolean bl) {
        return this.groupData != null && (bl || this.groupData.isCurrentGroup()) ? this.groupData : null;
    }

    @Override
    public void setDistinct() {
        if (this.distinctExpressions != null) {
            throw DbException.getUnsupportedException("DISTINCT ON together with DISTINCT");
        }
        this.distinct = true;
    }

    public void setDistinct(Expression[] expressionArray) {
        if (this.distinct) {
            throw DbException.getUnsupportedException("DISTINCT ON together with DISTINCT");
        }
        this.distinctExpressions = expressionArray;
    }

    @Override
    public void setDistinctIfPossible() {
        if (!this.isAnyDistinct() && this.offsetExpr == null && this.limitExpr == null) {
            this.distinct = true;
        }
    }

    @Override
    public boolean isAnyDistinct() {
        return this.distinct || this.distinctExpressions != null;
    }

    public boolean addWindow(String string, Window window) {
        if (this.windows == null) {
            this.windows = new HashMap();
        }
        return this.windows.put(string, window) == null;
    }

    public Window getWindow(String string) {
        return this.windows != null ? this.windows.get(string) : null;
    }

    public void addCondition(Expression expression) {
        this.condition = this.condition == null ? expression : new ConditionAndOr(0, expression, this.condition);
    }

    public Expression getCondition() {
        return this.condition;
    }

    private LazyResult queryGroupSorted(int n, ResultTarget resultTarget, long l, boolean bl) {
        LazyResultGroupSorted lazyResultGroupSorted = new LazyResultGroupSorted(this.expressionArray, n);
        Select.skipOffset(lazyResultGroupSorted, l, bl);
        if (resultTarget == null) {
            return lazyResultGroupSorted;
        }
        while (lazyResultGroupSorted.next()) {
            resultTarget.addRow(lazyResultGroupSorted.currentRow());
        }
        return null;
    }

    Value[] createGroupSortedRow(Value[] valueArray, int n) {
        int n2;
        Value[] valueArray2 = new Value[n];
        for (n2 = 0; this.groupIndex != null && n2 < this.groupIndex.length; ++n2) {
            valueArray2[this.groupIndex[n2]] = valueArray[n2];
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (this.groupByExpression != null && this.groupByExpression[n2]) continue;
            Expression expression = (Expression)this.expressions.get(n2);
            valueArray2[n2] = expression.getValue(this.session);
        }
        if (this.isHavingNullOrFalse(valueArray2)) {
            return null;
        }
        valueArray2 = this.keepOnlyDistinct(valueArray2, n);
        return valueArray2;
    }

    private Value[] keepOnlyDistinct(Value[] valueArray, int n) {
        if (n == this.distinctColumnCount) {
            return valueArray;
        }
        return Arrays.copyOf(valueArray, this.distinctColumnCount);
    }

    private boolean isHavingNullOrFalse(Value[] valueArray) {
        return this.havingIndex >= 0 && !valueArray[this.havingIndex].getBoolean();
    }

    private Index getGroupSortedIndex() {
        if (this.groupIndex == null || this.groupByExpression == null) {
            return null;
        }
        ArrayList<Index> arrayList = this.topTableFilter.getTable().getIndexes();
        if (arrayList != null) {
            for (Index index : arrayList) {
                if (index.getIndexType().isScan() || index.getIndexType().isHash() || !this.isGroupSortedIndex(this.topTableFilter, index)) continue;
                return index;
            }
        }
        return null;
    }

    private boolean isGroupSortedIndex(TableFilter tableFilter, Index index) {
        int n;
        Column[] columnArray = index.getColumns();
        boolean[] blArray = new boolean[columnArray.length];
        int n2 = this.expressions.size();
        block0: for (n = 0; n < n2; ++n) {
            if (!this.groupByExpression[n]) continue;
            Expression expression = ((Expression)this.expressions.get(n)).getNonAliasExpression();
            if (!(expression instanceof ExpressionColumn)) {
                return false;
            }
            ExpressionColumn expressionColumn = (ExpressionColumn)expression;
            for (int i = 0; i < columnArray.length; ++i) {
                if (tableFilter != expressionColumn.getTableFilter() || !columnArray[i].equals(expressionColumn.getColumn())) continue;
                blArray[i] = true;
                continue block0;
            }
            return false;
        }
        for (n = 1; n < blArray.length; ++n) {
            if (blArray[n - 1] || !blArray[n]) continue;
            return false;
        }
        return true;
    }

    private int getGroupByExpressionCount() {
        if (this.groupByExpression == null) {
            return 0;
        }
        int n = 0;
        for (boolean bl : this.groupByExpression) {
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    boolean isConditionMetForUpdate() {
        if (this.isConditionMet()) {
            int n = this.filters.size();
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                TableFilter tableFilter = this.filters.get(i);
                if (tableFilter.isJoinOuter() || tableFilter.isJoinOuterIndirect()) continue;
                Row row = tableFilter.get();
                Table table = tableFilter.getTable();
                if (!table.isMVStore()) continue;
                Row row2 = table.lockRow(this.session, row);
                if (row2 == null) {
                    return false;
                }
                if (row.hasSharedData(row2)) continue;
                tableFilter.set(row2);
                bl = false;
            }
            return bl || this.isConditionMet();
        }
        return false;
    }

    boolean isConditionMet() {
        return this.condition == null || this.condition.getBooleanValue(this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryWindow(int n, LocalResult localResult, long l, boolean bl) {
        this.initGroupData(n);
        try {
            this.gatherGroup(n, 2);
            this.processGroupResult(n, localResult, l, bl, false);
        }
        finally {
            this.groupData.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryGroupWindow(int n, LocalResult localResult, long l, boolean bl) {
        this.initGroupData(n);
        try {
            this.gatherGroup(n, 1);
            try {
                this.isGroupWindowStage2 = true;
                while (this.groupData.next() != null) {
                    if (this.havingIndex < 0 || ((Expression)this.expressions.get(this.havingIndex)).getBooleanValue(this.session)) {
                        this.updateAgg(n, 2);
                        continue;
                    }
                    this.groupData.remove();
                }
                this.groupData.done();
                this.processGroupResult(n, localResult, l, bl, false);
            }
            finally {
                this.isGroupWindowStage2 = false;
            }
        }
        finally {
            this.groupData.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryGroup(int n, LocalResult localResult, long l, boolean bl) {
        this.initGroupData(n);
        try {
            this.gatherGroup(n, 1);
            this.processGroupResult(n, localResult, l, bl, true);
        }
        finally {
            this.groupData.reset();
        }
    }

    private void initGroupData(int n) {
        if (this.groupData == null) {
            this.setGroupData(SelectGroups.getInstance(this.session, this.expressions, this.isGroupQuery, this.groupIndex));
        } else {
            this.updateAgg(n, 0);
        }
        this.groupData.reset();
    }

    void setGroupData(final SelectGroups selectGroups) {
        this.groupData = selectGroups;
        this.topTableFilter.visit(new TableFilter.TableFilterVisitor(){

            @Override
            public void accept(TableFilter tableFilter) {
                Select select = tableFilter.getSelect();
                if (select != null) {
                    select.groupData = selectGroups;
                }
            }
        });
    }

    private void gatherGroup(int n, int n2) {
        long l = 0L;
        this.setCurrentRowNumber(0L);
        int n3 = this.getSampleSizeValue(this.session);
        while (this.topTableFilter.next()) {
            this.setCurrentRowNumber(l + 1L);
            if (!(this.isForUpdateMvcc ? this.isConditionMetForUpdate() : this.isConditionMet())) continue;
            this.groupData.nextSource();
            this.updateAgg(n, n2);
            if (n3 <= 0 || ++l < (long)n3) continue;
        }
        this.groupData.done();
    }

    void updateAgg(int n, int n2) {
        for (int i = 0; i < n; ++i) {
            if (this.groupByExpression != null && this.groupByExpression[i] || this.groupByCopies != null && this.groupByCopies[i] >= 0) continue;
            Expression expression = (Expression)this.expressions.get(i);
            expression.updateAggregate(this.session, n2);
        }
    }

    private void processGroupResult(int n, LocalResult localResult, long l, boolean bl, boolean bl2) {
        ValueRow valueRow;
        while ((valueRow = this.groupData.next()) != null) {
            int n2;
            Value[] valueArray = valueRow.getList();
            Value[] valueArray2 = new Value[n];
            for (n2 = 0; this.groupIndex != null && n2 < this.groupIndex.length; ++n2) {
                valueArray2[this.groupIndex[n2]] = valueArray[n2];
            }
            for (n2 = 0; n2 < n; ++n2) {
                int n3;
                if (this.groupByExpression != null && this.groupByExpression[n2]) continue;
                if (this.groupByCopies != null && (n3 = this.groupByCopies[n2]) >= 0) {
                    valueArray2[n2] = valueArray2[n3];
                    continue;
                }
                Expression expression = (Expression)this.expressions.get(n2);
                valueArray2[n2] = expression.getValue(this.session);
            }
            if (bl2 && this.isHavingNullOrFalse(valueArray2) || this.qualifyIndex >= 0 && !valueArray2[this.qualifyIndex].getBoolean()) continue;
            if (bl && l > 0L) {
                --l;
                continue;
            }
            valueArray2 = this.keepOnlyDistinct(valueArray2, n);
            localResult.addRow(valueArray2);
        }
    }

    private Index getSortIndex() {
        Index index;
        IndexColumn[] indexColumnArray;
        if (this.sort == null) {
            return null;
        }
        ArrayList<Column> arrayList = Utils.newSmallArrayList();
        for (int n : this.sort.getQueryColumnIndexes()) {
            if (n < 0 || n >= this.expressions.size()) {
                throw DbException.getInvalidValueException("ORDER BY", n + 1);
            }
            Expression expression2 = (Expression)this.expressions.get(n);
            expression2 = expression2.getNonAliasExpression();
            if (expression2.isConstant()) continue;
            if (!(expression2 instanceof ExpressionColumn)) {
                return null;
            }
            indexColumnArray = (IndexColumn[])expression2;
            if (indexColumnArray.getTableFilter() != this.topTableFilter) {
                return null;
            }
            arrayList.add(indexColumnArray.getColumn());
        }
        Column[] columnArray = arrayList.toArray(new Column[0]);
        if (columnArray.length == 0) {
            return this.topTableFilter.getTable().getScanIndex(this.session);
        }
        ArrayList<Index> arrayList2 = this.topTableFilter.getTable().getIndexes();
        if (arrayList2 != null) {
            int[] index2 = this.sort.getSortTypesWithNullPosition();
            for (Index index3 : arrayList2) {
                if (index3.getCreateSQL() == null || index3.getIndexType().isHash() || (indexColumnArray = index3.getIndexColumns()).length < columnArray.length) continue;
                boolean bl = true;
                for (int i = 0; i < columnArray.length; ++i) {
                    IndexColumn indexColumn = indexColumnArray[i];
                    Column column = columnArray[i];
                    if (indexColumn.column != column) {
                        bl = false;
                        break;
                    }
                    if (SortOrder.addExplicitNullPosition(indexColumn.sortType) == index2[i]) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                return index3;
            }
        }
        if (columnArray.length == 1 && columnArray[0].getColumnId() == -1 && (index = this.topTableFilter.getTable().getScanIndex(this.session)).isRowIdIndex()) {
            return index;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void queryDistinct(ResultTarget resultTarget, long l, long l2, boolean bl, boolean bl2) {
        if (l2 > 0L && l > 0L && (l2 += l) < 0L) {
            l2 = Long.MAX_VALUE;
        }
        long l3 = 0L;
        this.setCurrentRowNumber(0L);
        Index index = this.topTableFilter.getIndex();
        SearchRow searchRow = null;
        int n = index.getColumns()[0].getColumnId();
        int n2 = this.getSampleSizeValue(this.session);
        if (!bl2) {
            l = 0L;
        }
        while (true) {
            this.setCurrentRowNumber(++l3);
            Cursor cursor = index.findNext(this.session, searchRow, null);
            if (!cursor.next()) return;
            SearchRow searchRow2 = cursor.getSearchRow();
            Value value = searchRow2.getValue(n);
            if (searchRow == null) {
                searchRow = this.topTableFilter.getTable().getTemplateSimpleRow(true);
            }
            searchRow.setValue(n, value);
            if (l > 0L) {
                --l;
                continue;
            }
            Value[] valueArray = new Value[]{value};
            resultTarget.addRow(valueArray);
            if ((this.sort == null || this.sortUsingIndex) && l2 > 0L && l3 >= l2 && !bl || n2 > 0 && l3 >= (long)n2) return;
        }
    }

    private LazyResult queryFlat(int n, ResultTarget resultTarget, long l, long l2, boolean bl, boolean bl2) {
        if (l2 > 0L && l > 0L && !bl2 && (l2 += l) < 0L) {
            l2 = Long.MAX_VALUE;
        }
        int n2 = this.getSampleSizeValue(this.session);
        LazyResultQueryFlat lazyResultQueryFlat = new LazyResultQueryFlat(this.expressionArray, n, n2, this.isForUpdateMvcc);
        Select.skipOffset(lazyResultQueryFlat, l, bl2);
        if (resultTarget == null) {
            return lazyResultQueryFlat;
        }
        if (l2 < 0L || this.sort != null && !this.sortUsingIndex || bl && !bl2) {
            l2 = Long.MAX_VALUE;
        }
        Value[] valueArray = null;
        while ((long)resultTarget.getRowCount() < l2 && lazyResultQueryFlat.next()) {
            valueArray = lazyResultQueryFlat.currentRow();
            resultTarget.addRow(valueArray);
        }
        if (l2 != Long.MAX_VALUE && bl && this.sort != null && valueArray != null) {
            Value[] valueArray2 = valueArray;
            while (lazyResultQueryFlat.next() && this.sort.compare(valueArray2, valueArray = lazyResultQueryFlat.currentRow()) == 0) {
                resultTarget.addRow(valueArray);
            }
            resultTarget.limitsWereApplied();
        }
        return null;
    }

    private static void skipOffset(LazyResultSelect lazyResultSelect, long l, boolean bl) {
        if (bl) {
            while (l > 0L && lazyResultSelect.skip()) {
                --l;
            }
        }
    }

    private void queryQuick(int n, ResultTarget resultTarget, boolean bl) {
        Value[] valueArray = new Value[n];
        for (int i = 0; i < n; ++i) {
            Expression expression = (Expression)this.expressions.get(i);
            valueArray[i] = expression.getValue(this.session);
        }
        if (!bl) {
            resultTarget.addRow(valueArray);
        }
    }

    @Override
    public ResultInterface queryMeta() {
        LocalResult localResult = this.session.getDatabase().getResultFactory().create(this.session, this.expressionArray, this.visibleColumnCount);
        localResult.done();
        return localResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ResultInterface queryWithoutCache(int n, ResultTarget resultTarget) {
        boolean bl;
        long l;
        boolean bl2;
        int n2;
        this.disableLazyForJoinSubqueries(this.topTableFilter);
        int n3 = n2 = n == 0 ? -1 : n;
        if (this.limitExpr != null) {
            int n4;
            Value value = this.limitExpr.getValue(this.session);
            int n5 = n4 = value == ValueNull.INSTANCE ? -1 : value.getInt();
            if (n2 < 0) {
                n2 = n4;
            } else if (n4 >= 0) {
                n2 = Math.min(n4, n2);
            }
        }
        if (bl2 = this.fetchPercent) {
            if (n2 < 0 || n2 > 100) {
                throw DbException.getInvalidValueException("FETCH PERCENT", n2);
            }
            if (n2 == 0) {
                bl2 = false;
            }
        }
        if (this.offsetExpr != null) {
            l = this.offsetExpr.getValue(this.session).getLong();
            if (l < 0L) {
                l = 0L;
            }
        } else {
            l = 0L;
        }
        boolean bl3 = this.session.isLazyQueryExecution() && resultTarget == null && !this.isForUpdate && !this.isQuickAggregateQuery && n2 != 0 && !bl2 && !this.withTies && l == 0L && this.isReadOnly();
        int n6 = this.expressions.size();
        LocalResult localResult = null;
        if (!(bl3 || resultTarget != null && this.session.getDatabase().getSettings().optimizeInsertFromSelect)) {
            localResult = this.createLocalResult(localResult);
        }
        boolean bl4 = bl = !bl2;
        if (this.sort != null && (!this.sortUsingIndex || this.isAnyDistinct())) {
            localResult = this.createLocalResult(localResult);
            localResult.setSortOrder(this.sort);
            if (!this.sortUsingIndex) {
                bl = false;
            }
        }
        if (this.distinct) {
            if (!this.isDistinctQuery) {
                bl = false;
                localResult = this.createLocalResult(localResult);
                localResult.setDistinct();
            }
        } else if (this.distinctExpressions != null) {
            bl = false;
            localResult = this.createLocalResult(localResult);
            localResult.setDistinct(this.distinctIndexes);
        }
        if (this.isWindowQuery || this.isGroupQuery && !this.isGroupSortedQuery) {
            localResult = this.createLocalResult(localResult);
        }
        if (!(bl3 || n2 < 0 && l <= 0L)) {
            localResult = this.createLocalResult(localResult);
        }
        this.topTableFilter.startQuery(this.session);
        this.topTableFilter.reset();
        boolean bl5 = this.isForUpdate && !this.isForUpdateMvcc;
        this.topTableFilter.lock(this.session, bl5, bl5);
        ResultTarget resultTarget2 = localResult != null ? localResult : resultTarget;
        bl3 &= resultTarget2 == null;
        LazyResult lazyResult = null;
        if (n2 != 0) {
            int n7 = bl2 ? -1 : n2;
            try {
                if (this.isQuickAggregateQuery) {
                    this.queryQuick(n6, resultTarget2, bl && l > 0L);
                } else if (this.isWindowQuery) {
                    if (this.isGroupQuery) {
                        this.queryGroupWindow(n6, localResult, l, bl);
                    } else {
                        this.queryWindow(n6, localResult, l, bl);
                    }
                } else if (this.isGroupQuery) {
                    if (this.isGroupSortedQuery) {
                        lazyResult = this.queryGroupSorted(n6, resultTarget2, l, bl);
                    } else {
                        this.queryGroup(n6, localResult, l, bl);
                    }
                } else if (this.isDistinctQuery) {
                    this.queryDistinct(resultTarget2, l, n7, this.withTies, bl);
                } else {
                    lazyResult = this.queryFlat(n6, resultTarget2, l, n7, this.withTies, bl);
                }
                if (bl) {
                    l = 0L;
                }
            }
            finally {
                if (!bl3) {
                    this.resetJoinBatchAfterQuery();
                }
            }
        }
        assert (bl3 == (lazyResult != null)) : bl3;
        if (lazyResult != null) {
            if (n2 > 0) {
                lazyResult.setLimit(n2);
            }
            if (this.randomAccessResult) {
                return this.convertToDistinct(lazyResult);
            }
            return lazyResult;
        }
        if (l != 0L) {
            if (l > Integer.MAX_VALUE) {
                throw DbException.getInvalidValueException("OFFSET", l);
            }
            localResult.setOffset((int)l);
        }
        if (n2 >= 0) {
            localResult.setLimit(n2);
            localResult.setFetchPercent(bl2);
            if (this.withTies) {
                localResult.setWithTies(this.sort);
            }
        }
        if (localResult != null) {
            localResult.done();
            if (this.randomAccessResult && !this.distinct) {
                localResult = this.convertToDistinct(localResult);
            }
            if (resultTarget != null) {
                while (localResult.next()) {
                    resultTarget.addRow(localResult.currentRow());
                }
                localResult.close();
                return null;
            }
            return localResult;
        }
        return null;
    }

    private void disableLazyForJoinSubqueries(final TableFilter tableFilter) {
        if (this.session.isLazyQueryExecution()) {
            tableFilter.visit(new TableFilter.TableFilterVisitor(){

                @Override
                public void accept(TableFilter tableFilter2) {
                    ViewIndex viewIndex;
                    if (tableFilter2 != tableFilter && tableFilter2.getTable().getTableType() == TableType.VIEW && (viewIndex = (ViewIndex)tableFilter2.getIndex()) != null && viewIndex.getQuery() != null) {
                        viewIndex.getQuery().setNeverLazy(true);
                    }
                }
            });
        }
    }

    void resetJoinBatchAfterQuery() {
        JoinBatch joinBatch = this.getJoinBatch();
        if (joinBatch != null) {
            joinBatch.reset(false);
        }
    }

    private LocalResult createLocalResult(LocalResult localResult) {
        return localResult != null ? localResult : this.session.getDatabase().getResultFactory().create(this.session, this.expressionArray, this.visibleColumnCount);
    }

    private LocalResult convertToDistinct(ResultInterface resultInterface) {
        LocalResult localResult = this.session.getDatabase().getResultFactory().create(this.session, this.expressionArray, this.visibleColumnCount);
        localResult.setDistinct();
        resultInterface.reset();
        while (resultInterface.next()) {
            localResult.addRow(resultInterface.currentRow());
        }
        resultInterface.close();
        localResult.done();
        return localResult;
    }

    private void expandColumnList() {
        int n = 0;
        while (n < this.expressions.size()) {
            Expression expression = (Expression)this.expressions.get(n);
            if (!(expression instanceof Wildcard)) {
                ++n;
                continue;
            }
            this.expressions.remove(n);
            Wildcard wildcard = (Wildcard)expression;
            String string = wildcard.getTableAlias();
            boolean bl = wildcard.getExceptColumns() != null;
            HashMap<Column, ExpressionColumn> hashMap = null;
            if (string == null) {
                if (bl) {
                    for (TableFilter tableFilter : this.filters) {
                        wildcard.mapColumns(tableFilter, 1, 0);
                    }
                    hashMap = wildcard.mapExceptColumns();
                }
                for (TableFilter tableFilter : this.filters) {
                    n = this.expandColumnList(tableFilter, n, hashMap);
                }
                continue;
            }
            Iterator<TableFilter> iterator = this.session.getDatabase();
            String string2 = wildcard.getSchemaName();
            TableFilter tableFilter = null;
            for (TableFilter tableFilter2 : this.filters) {
                if (!((Database)((Object)iterator)).equalsIdentifiers(string, tableFilter2.getTableAlias()) || string2 != null && !((Database)((Object)iterator)).equalsIdentifiers(string2, tableFilter2.getSchemaName())) continue;
                if (bl) {
                    wildcard.mapColumns(tableFilter2, 1, 0);
                    hashMap = wildcard.mapExceptColumns();
                }
                tableFilter = tableFilter2;
                break;
            }
            if (tableFilter == null) {
                throw DbException.get(42102, string);
            }
            n = this.expandColumnList(tableFilter, n, hashMap);
        }
    }

    private int expandColumnList(TableFilter tableFilter, int n, HashMap<Column, ExpressionColumn> hashMap) {
        String string = tableFilter.getTableAlias();
        for (Column column : tableFilter.getTable().getColumns()) {
            if (hashMap != null && hashMap.remove(column) != null || !column.getVisible() || tableFilter.isNaturalJoinColumn(column)) continue;
            String string2 = tableFilter.getDerivedColumnName(column);
            ExpressionColumn expressionColumn = new ExpressionColumn(this.session.getDatabase(), null, string, string2 != null ? string2 : column.getName(), false);
            this.expressions.add(n++, expressionColumn);
        }
        return n;
    }

    @Override
    public void init() {
        int n;
        ArrayList<String> arrayList;
        if (this.checkInit) {
            DbException.throwInternalError();
        }
        this.expandColumnList();
        this.visibleColumnCount = this.expressions.size();
        if (this.distinctExpressions != null || this.orderList != null || this.group != null) {
            arrayList = new ArrayList<String>(this.visibleColumnCount);
            for (int i = 0; i < this.visibleColumnCount; ++i) {
                Object object = (Expression)this.expressions.get(i);
                object = ((Expression)object).getNonAliasExpression();
                String string = ((Expression)object).getSQL(true);
                arrayList.add(string);
            }
        } else {
            arrayList = null;
        }
        if (this.distinctExpressions != null) {
            BitSet bitSet = new BitSet();
            for (Expression object2 : this.distinctExpressions) {
                bitSet.set(Select.initExpression(this.session, this.expressions, arrayList, object2, this.visibleColumnCount, false, this.filters));
            }
            int n2 = 0;
            int n3 = bitSet.cardinality();
            this.distinctIndexes = new int[n3];
            for (n = 0; n < n3; ++n) {
                n2 = bitSet.nextSetBit(n2);
                this.distinctIndexes[n] = n2++;
            }
        }
        if (this.orderList != null) {
            Select.initOrder(this.session, this.expressions, arrayList, this.orderList, this.visibleColumnCount, this.isAnyDistinct(), this.filters);
        }
        this.distinctColumnCount = this.expressions.size();
        if (this.having != null) {
            this.expressions.add(this.having);
            this.havingIndex = this.expressions.size() - 1;
            this.having = null;
        } else {
            this.havingIndex = -1;
        }
        if (this.qualify != null) {
            this.expressions.add(this.qualify);
            this.qualifyIndex = this.expressions.size() - 1;
            this.qualify = null;
        } else {
            this.qualifyIndex = -1;
        }
        if (this.withTies && !this.hasOrder()) {
            throw DbException.get(90122);
        }
        Database database = this.session.getDatabase();
        if (this.group != null) {
            block25: {
                int n4 = this.group.size();
                int n5 = arrayList.size();
                this.groupIndex = new int[n4];
                for (n = 0; n < n4; ++n) {
                    Object object;
                    int n2;
                    Expression expression = this.group.get(n);
                    String string = expression.getSQL(true);
                    int n3 = -1;
                    for (n2 = 0; n2 < n5; ++n2) {
                        object = arrayList.get(n2);
                        if (!database.equalsIdentifiers((String)object, string)) continue;
                        n3 = this.mergeGroupByExpressions(database, n2, arrayList, false);
                        break;
                    }
                    if (n3 < 0) {
                        for (n2 = 0; n2 < n5; ++n2) {
                            object = (Expression)this.expressions.get(n2);
                            if (database.equalsIdentifiers(string, ((Expression)object).getAlias())) {
                                n3 = this.mergeGroupByExpressions(database, n2, arrayList, true);
                                break;
                            }
                            string = expression.getAlias();
                            if (!database.equalsIdentifiers(string, ((Expression)object).getAlias())) continue;
                            n3 = this.mergeGroupByExpressions(database, n2, arrayList, true);
                            break;
                        }
                    }
                    if (n3 < 0) {
                        this.groupIndex[n] = n2 = this.expressions.size();
                        this.expressions.add(expression);
                        continue;
                    }
                    this.groupIndex[n] = n3;
                }
                if (this.groupByCopies != null) {
                    for (int n3 : this.groupByCopies) {
                        if (n3 < 0) {
                            continue;
                        }
                        break block25;
                    }
                    this.groupByCopies = null;
                }
            }
            this.groupByExpression = new boolean[this.expressions.size()];
            for (int n3 : this.groupIndex) {
                this.groupByExpression[n3] = true;
            }
            this.group = null;
        }
        for (TableFilter tableFilter : this.filters) {
            this.mapColumns(tableFilter, 0);
        }
        this.mapCondition(this.havingIndex);
        this.mapCondition(this.qualifyIndex);
        this.checkInit = true;
    }

    private void mapCondition(int n) {
        if (n >= 0) {
            Expression expression = (Expression)this.expressions.get(n);
            SelectListColumnResolver selectListColumnResolver = new SelectListColumnResolver(this);
            expression.mapColumns(selectListColumnResolver, 0, 0);
        }
    }

    private int mergeGroupByExpressions(Database database, int n, ArrayList<String> arrayList, boolean bl) {
        int n2;
        if (this.groupByCopies != null) {
            int n3 = this.groupByCopies[n];
            if (n3 >= 0) {
                return n3;
            }
            if (n3 == -2) {
                return n;
            }
        } else {
            this.groupByCopies = new int[arrayList.size()];
            Arrays.fill(this.groupByCopies, -1);
        }
        String string = arrayList.get(n);
        if (bl) {
            for (n2 = 0; n2 < n; ++n2) {
                if (!database.equalsIdentifiers(string, arrayList.get(n2))) continue;
                n = n2;
                break;
            }
        }
        n2 = arrayList.size();
        for (int i = n + 1; i < n2; ++i) {
            if (!database.equalsIdentifiers(string, arrayList.get(i))) continue;
            this.groupByCopies[i] = n;
        }
        this.groupByCopies[n] = -2;
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void prepare() {
        boolean bl;
        Object object;
        if (this.isPrepared) {
            return;
        }
        if (!this.checkInit) {
            DbException.throwInternalError("not initialized");
        }
        if (this.orderList != null) {
            this.sort = this.prepareOrder(this.orderList, this.expressions.size());
            this.orderList = null;
        }
        ColumnNamer columnNamer = new ColumnNamer(this.session);
        for (int i = 0; i < this.expressions.size(); ++i) {
            void object22;
            String string;
            Expression expression = (Expression)this.expressions.get(i);
            object = columnNamer.getColumnName(expression, i, string = expression.getAlias());
            if (!((String)object).equals(string)) {
                Alias alias = new Alias(expression, (String)object, true);
            }
            this.expressions.set(i, object22.optimize(this.session));
        }
        if (this.condition != null) {
            this.condition = this.condition.optimize(this.session);
            for (TableFilter tableFilter : this.filters) {
                if (tableFilter.isJoinOuter() || tableFilter.isJoinOuterIndirect()) continue;
                this.condition.createIndexConditions(this.session, tableFilter);
            }
        }
        if (this.isGroupQuery && this.groupIndex == null && this.havingIndex < 0 && this.qualifyIndex < 0 && this.condition == null && this.filters.size() == 1) {
            this.isQuickAggregateQuery = this.isEverything(ExpressionVisitor.getOptimizableVisitor(this.filters.get(0).getTable()));
        }
        this.cost = this.preparePlan(this.session.isParsingCreateView());
        if (this.distinct && this.session.getDatabase().getSettings().optimizeDistinct && !this.isGroupQuery && this.filters.size() == 1 && this.expressions.size() == 1 && this.condition == null) {
            Expression expression = (Expression)this.expressions.get(0);
            if ((expression = expression.getNonAliasExpression()) instanceof ExpressionColumn) {
                Column column = ((ExpressionColumn)expression).getColumn();
                int n = column.getSelectivity();
                object = this.topTableFilter.getTable().getIndexForColumn(column, false, true);
                if (object != null && n != 50 && n < 20) {
                    IndexType indexType;
                    bl = object.getIndexColumns()[0].sortType == 0;
                    Index index = this.topTableFilter.getIndex();
                    if (!(!object.canFindNext() || !bl || index != null && !index.getIndexType().isScan() && object != index || (indexType = object.getIndexType()).isHash() || indexType.isUnique() && object.getColumns().length <= 1)) {
                        this.topTableFilter.setIndex((Index)object);
                        this.isDistinctQuery = true;
                    }
                }
            }
        }
        if (this.sort != null && !this.isQuickAggregateQuery && !this.isGroupQuery) {
            Index index = this.getSortIndex();
            Index index2 = this.topTableFilter.getIndex();
            if (index != null && index2 != null) {
                if (index2.getIndexType().isScan() || index2 == index) {
                    this.topTableFilter.setIndex(index);
                    if (!this.topTableFilter.hasInComparisons()) {
                        this.sortUsingIndex = true;
                    }
                } else if (index.getIndexColumns() != null && index.getIndexColumns().length >= index2.getIndexColumns().length) {
                    IndexColumn[] indexColumnArray = index.getIndexColumns();
                    object = index2.getIndexColumns();
                    bl = false;
                    for (int i = 0; i < ((IndexColumn[])object).length; ++i) {
                        if (indexColumnArray[i].column != object[i].column) {
                            bl = false;
                            break;
                        }
                        if (indexColumnArray[i].sortType == ((IndexColumn)object[i]).sortType) continue;
                        bl = true;
                    }
                    if (bl) {
                        this.topTableFilter.setIndex(index);
                        this.sortUsingIndex = true;
                    }
                }
            }
            if (this.sortUsingIndex && this.isForUpdateMvcc && !this.topTableFilter.getIndex().isRowIdIndex()) {
                this.sortUsingIndex = false;
            }
        }
        if (!this.isQuickAggregateQuery && this.isGroupQuery && this.getGroupByExpressionCount() > 0) {
            Index index = this.getGroupSortedIndex();
            Index index3 = this.topTableFilter.getIndex();
            if (index != null && index3 != null && (index3.getIndexType().isScan() || index3 == index)) {
                this.topTableFilter.setIndex(index);
                this.isGroupSortedQuery = true;
            }
        }
        this.expressionArray = this.expressions.toArray(new Expression[0]);
        this.isPrepared = true;
    }

    @Override
    public void prepareJoinBatch() {
        ArrayList<TableFilter> arrayList = new ArrayList<TableFilter>();
        TableFilter tableFilter = this.getTopTableFilter();
        do {
            if (tableFilter.getNestedJoin() != null) {
                return;
            }
            arrayList.add(tableFilter);
        } while ((tableFilter = tableFilter.getJoin()) != null);
        TableFilter[] tableFilterArray = arrayList.toArray(new TableFilter[0]);
        JoinBatch joinBatch = null;
        for (int i = tableFilterArray.length - 1; i >= 0; --i) {
            joinBatch = tableFilterArray[i].prepareJoinBatch(joinBatch, tableFilterArray, i);
        }
    }

    public JoinBatch getJoinBatch() {
        return this.getTopTableFilter().getJoinBatch();
    }

    @Override
    public double getCost() {
        return this.cost;
    }

    @Override
    public HashSet<Table> getTables() {
        HashSet<Table> hashSet = new HashSet<Table>();
        for (TableFilter tableFilter : this.filters) {
            hashSet.add(tableFilter.getTable());
        }
        return hashSet;
    }

    @Override
    public void fireBeforeSelectTriggers() {
        for (TableFilter tableFilter : this.filters) {
            tableFilter.getTable().fire(this.session, 8, true);
        }
    }

    private double preparePlan(boolean bl) {
        TableFilter[] tableFilterArray = this.topFilters.toArray(new TableFilter[0]);
        for (TableFilter tableFilter : tableFilterArray) {
            tableFilter.createIndexConditions();
            tableFilter.setFullCondition(this.condition);
        }
        Optimizer optimizer = new Optimizer(tableFilterArray, this.condition, this.session);
        optimizer.optimize(bl);
        this.topTableFilter = optimizer.getTopFilter();
        double d = optimizer.getCost();
        this.setEvaluatableRecursive(this.topTableFilter);
        if (!bl) {
            this.topTableFilter.prepare();
        }
        return d;
    }

    private void setEvaluatableRecursive(TableFilter tableFilter) {
        while (tableFilter != null) {
            Expression expression;
            TableFilter tableFilter2;
            tableFilter.setEvaluatable(tableFilter, true);
            if (this.condition != null) {
                this.condition.setEvaluatable(tableFilter, true);
            }
            if ((tableFilter2 = tableFilter.getNestedJoin()) != null) {
                this.setEvaluatableRecursive(tableFilter2);
            }
            if ((expression = tableFilter.getJoinCondition()) != null && !expression.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) {
                expression = expression.optimize(this.session);
                if (!tableFilter.isJoinOuter() && !tableFilter.isJoinOuterIndirect()) {
                    tableFilter.removeJoinCondition();
                    this.addCondition(expression);
                }
            }
            if ((expression = tableFilter.getFilterCondition()) != null && !expression.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) {
                tableFilter.removeFilterCondition();
                this.addCondition(expression);
            }
            for (Expression expression2 : this.expressions) {
                expression2.setEvaluatable(tableFilter, true);
            }
            tableFilter = tableFilter.getJoin();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getPlanSQL(boolean bl) {
        int n;
        Expression[] expressionArray = this.expressions.toArray(new Expression[0]);
        StringBuilder stringBuilder = new StringBuilder();
        for (TableFilter tableFilter : this.topFilters) {
            Table table = tableFilter.getTable();
            TableView object = table.isView() ? (TableView)table : null;
            if (object == null || !object.isRecursive() || !object.isTableExpression() || !object.isTemporary()) continue;
            stringBuilder.append("WITH RECURSIVE ");
            table.getSchema().getSQL(stringBuilder, bl).append('.');
            Parser.quoteIdentifier(stringBuilder, table.getName(), bl).append('(');
            Column.writeColumns(stringBuilder, table.getColumns(), bl);
            stringBuilder.append(") AS ");
            table.getSQL(stringBuilder, bl).append('\n');
        }
        stringBuilder.append("SELECT");
        if (this.isAnyDistinct()) {
            stringBuilder.append(" DISTINCT");
            if (this.distinctExpressions != null) {
                stringBuilder.append(" ON(");
                Expression.writeExpressions(stringBuilder, this.distinctExpressions, bl);
                stringBuilder.append(')');
            }
        }
        for (int i = 0; i < this.visibleColumnCount; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('\n');
            StringUtils.indent(stringBuilder, expressionArray[i].getSQL(bl), 4, false);
        }
        stringBuilder.append("\nFROM ");
        TableFilter tableFilter = this.topTableFilter;
        if (tableFilter != null) {
            n = 0;
            do {
                if (n > 0) {
                    stringBuilder.append('\n');
                }
                tableFilter.getPlanSQL(stringBuilder, n++ > 0, bl);
            } while ((tableFilter = tableFilter.getJoin()) != null);
        } else {
            n = 0;
            for (TableFilter tableFilter2 : this.topFilters) {
                void var7_16;
                TableFilter tableFilter3;
                do {
                    if (n > 0) {
                        stringBuilder.append('\n');
                    }
                    var7_16.getPlanSQL(stringBuilder, n++ > 0, bl);
                } while ((tableFilter3 = var7_16.getJoin()) != null);
            }
        }
        if (this.condition != null) {
            stringBuilder.append("\nWHERE ");
            this.condition.getUnenclosedSQL(stringBuilder, bl);
        }
        if (this.groupIndex != null) {
            stringBuilder.append("\nGROUP BY ");
            int n2 = this.groupIndex.length;
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuilder.append(", ");
                }
                expressionArray[this.groupIndex[n]].getNonAliasExpression().getUnenclosedSQL(stringBuilder, bl);
            }
        } else if (this.group != null) {
            stringBuilder.append("\nGROUP BY ");
            int n3 = this.group.size();
            for (n = 0; n < n3; ++n) {
                if (n > 0) {
                    stringBuilder.append(", ");
                }
                this.group.get(n).getUnenclosedSQL(stringBuilder, bl);
            }
        }
        Select.getFilterSQL(stringBuilder, "\nHAVING ", expressionArray, this.having, this.havingIndex);
        Select.getFilterSQL(stringBuilder, "\nQUALIFY ", expressionArray, this.qualify, this.qualifyIndex);
        if (this.sort != null) {
            stringBuilder.append("\nORDER BY ").append(this.sort.getSQL(expressionArray, this.visibleColumnCount, bl));
        }
        if (this.orderList != null) {
            stringBuilder.append("\nORDER BY ");
            int n4 = this.orderList.size();
            for (n = 0; n < n4; ++n) {
                if (n > 0) {
                    stringBuilder.append(", ");
                }
                ((SelectOrderBy)this.orderList.get(n)).getSQL(stringBuilder, bl);
            }
        }
        this.appendLimitToSQL(stringBuilder, bl);
        if (this.sampleSizeExpr != null) {
            stringBuilder.append("\nSAMPLE_SIZE ");
            this.sampleSizeExpr.getUnenclosedSQL(stringBuilder, bl);
        }
        if (this.isForUpdate) {
            stringBuilder.append("\nFOR UPDATE");
        }
        if (this.isQuickAggregateQuery) {
            stringBuilder.append("\n/* direct lookup */");
        }
        if (this.isDistinctQuery) {
            stringBuilder.append("\n/* distinct */");
        }
        if (this.sortUsingIndex) {
            stringBuilder.append("\n/* index sorted */");
        }
        if (this.isGroupQuery && this.isGroupSortedQuery) {
            stringBuilder.append("\n/* group sorted */");
        }
        return stringBuilder.toString();
    }

    private static void getFilterSQL(StringBuilder stringBuilder, String string, Expression[] expressionArray, Expression expression, int n) {
        if (expression != null) {
            stringBuilder.append(string);
            expression.getUnenclosedSQL(stringBuilder, true);
        } else if (n >= 0) {
            stringBuilder.append(string);
            expressionArray[n].getUnenclosedSQL(stringBuilder, true);
        }
    }

    public void setHaving(Expression expression) {
        this.having = expression;
    }

    public Expression getHaving() {
        return this.having;
    }

    public void setQualify(Expression expression) {
        this.qualify = expression;
    }

    public Expression getQualify() {
        return this.qualify;
    }

    @Override
    public int getColumnCount() {
        return this.visibleColumnCount;
    }

    public TableFilter getTopTableFilter() {
        return this.topTableFilter;
    }

    @Override
    public void setForUpdate(boolean bl) {
        if (bl && (this.isAnyDistinct() || this.isGroupQuery)) {
            throw DbException.get(90145);
        }
        this.isForUpdate = bl;
        if (this.session.getDatabase().isMVStore()) {
            this.isForUpdateMvcc = bl;
        }
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        for (Expression expression : this.expressions) {
            expression.mapColumns(columnResolver, n, 0);
        }
        if (this.condition != null) {
            this.condition.mapColumns(columnResolver, n, 0);
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (Expression expression : this.expressions) {
            expression.setEvaluatable(tableFilter, bl);
        }
        if (this.condition != null) {
            this.condition.setEvaluatable(tableFilter, bl);
        }
    }

    public boolean isQuickAggregateQuery() {
        return this.isQuickAggregateQuery;
    }

    public boolean isGroupQuery() {
        return this.isGroupQuery;
    }

    public boolean isWindowQuery() {
        return this.isWindowQuery;
    }

    public boolean isGroupWindowStage2() {
        return this.isGroupWindowStage2;
    }

    @Override
    public void addGlobalCondition(Parameter parameter, int n, int n2) {
        this.addParameter(parameter);
        Expression expression = (Expression)this.expressions.get(n);
        expression = expression.getNonAliasExpression();
        Expression expression2 = expression.isEverything(ExpressionVisitor.QUERY_COMPARABLE_VISITOR) ? new Comparison(this.session, n2, expression, parameter) : new Comparison(this.session, 16, parameter, parameter);
        expression2 = ((Expression)expression2).optimize(this.session);
        boolean bl = true;
        if (this.isWindowQuery) {
            this.qualify = this.qualify == null ? expression2 : new ConditionAndOr(0, expression2, this.qualify);
            return;
        }
        if (this.isGroupQuery) {
            bl = false;
            for (int i = 0; this.groupIndex != null && i < this.groupIndex.length; ++i) {
                if (this.groupIndex[i] != n) continue;
                bl = true;
                break;
            }
            if (!bl) {
                if (this.havingIndex >= 0) {
                    this.having = (Expression)this.expressions.get(this.havingIndex);
                }
                this.having = this.having == null ? expression2 : new ConditionAndOr(0, this.having, expression2);
            }
        }
        if (bl) {
            this.condition = this.condition == null ? expression2 : new ConditionAndOr(0, this.condition, expression2);
        }
    }

    @Override
    public void updateAggregate(Session session, int n) {
        for (Expression expression : this.expressions) {
            expression.updateAggregate(session, n);
        }
        if (this.condition != null) {
            this.condition.updateAggregate(session, n);
        }
        if (this.having != null) {
            this.having.updateAggregate(session, n);
        }
        if (this.qualify != null) {
            this.qualify.updateAggregate(session, n);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 2: {
                if (this.isForUpdate) {
                    return false;
                }
                for (TableFilter object : this.filters) {
                    if (object.getTable().isDeterministic()) continue;
                    return false;
                }
                break;
            }
            case 4: {
                for (TableFilter tableFilter : this.filters) {
                    long l = tableFilter.getTable().getMaxDataModificationId();
                    expressionVisitor.addDataModificationId(l);
                }
                break;
            }
            case 3: {
                if (this.session.getDatabase().getSettings().optimizeEvaluatableSubqueries) break;
                return false;
            }
            case 7: {
                for (TableFilter tableFilter : this.filters) {
                    Table table = tableFilter.getTable();
                    expressionVisitor.addDependency(table);
                    table.addDependencies(expressionVisitor.getDependencies());
                }
                break;
            }
        }
        Iterator<TableFilter> iterator = expressionVisitor.incrementQueryLevel(1);
        for (Expression expression : this.expressions) {
            if (expression.isEverything((ExpressionVisitor)((Object)iterator))) continue;
            return false;
        }
        if (this.condition != null && !this.condition.isEverything((ExpressionVisitor)((Object)iterator))) {
            return false;
        }
        if (this.having != null && !this.having.isEverything((ExpressionVisitor)((Object)iterator))) {
            return false;
        }
        return this.qualify == null || this.qualify.isEverything((ExpressionVisitor)((Object)iterator));
    }

    @Override
    public boolean isReadOnly() {
        return this.isEverything(ExpressionVisitor.READONLY_VISITOR);
    }

    @Override
    public boolean isCacheable() {
        return !this.isForUpdate;
    }

    @Override
    public boolean allowGlobalConditions() {
        return this.offsetExpr == null && (this.limitExpr == null && this.distinctExpressions == null || this.sort == null);
    }

    public SortOrder getSortOrder() {
        return this.sort;
    }

    public Select getParentSelect() {
        return this.parentSelect;
    }

    private final class LazyResultGroupSorted
    extends LazyResultSelect {
        private Value[] previousKeyValues;

        LazyResultGroupSorted(Expression[] expressionArray, int n) {
            super(expressionArray, n);
            if (Select.this.groupData == null) {
                Select.this.setGroupData(SelectGroups.getInstance(Select.this.getSession(), Select.this.expressions, Select.this.isGroupQuery, Select.this.groupIndex));
            } else {
                Select.this.updateAgg(n, 0);
                Select.this.groupData.resetLazy();
            }
        }

        @Override
        public void reset() {
            super.reset();
            Select.this.groupData.resetLazy();
            this.previousKeyValues = null;
        }

        @Override
        protected Value[] fetchNextRow() {
            Object[] objectArray;
            while (Select.this.topTableFilter.next()) {
                Select.this.setCurrentRowNumber(this.rowNumber + 1L);
                if (!Select.this.isConditionMet()) continue;
                ++this.rowNumber;
                objectArray = new Value[Select.this.groupIndex.length];
                for (int i = 0; i < Select.this.groupIndex.length; ++i) {
                    int n = Select.this.groupIndex[i];
                    Expression expression = (Expression)Select.this.expressions.get(n);
                    objectArray[i] = expression.getValue(Select.this.getSession());
                }
                Value[] valueArray = null;
                if (this.previousKeyValues == null) {
                    this.previousKeyValues = objectArray;
                    Select.this.groupData.nextLazyGroup();
                } else if (!Arrays.equals(this.previousKeyValues, objectArray)) {
                    valueArray = Select.this.createGroupSortedRow(this.previousKeyValues, this.columnCount);
                    this.previousKeyValues = objectArray;
                    Select.this.groupData.nextLazyGroup();
                }
                Select.this.groupData.nextLazyRow();
                Select.this.updateAgg(this.columnCount, 1);
                if (valueArray == null) continue;
                return valueArray;
            }
            objectArray = null;
            if (this.previousKeyValues != null) {
                objectArray = Select.this.createGroupSortedRow(this.previousKeyValues, this.columnCount);
                this.previousKeyValues = null;
            }
            return objectArray;
        }
    }

    private final class LazyResultQueryFlat
    extends LazyResultSelect {
        private int sampleSize;
        private boolean forUpdate;

        LazyResultQueryFlat(Expression[] expressionArray, int n, int n2, boolean bl) {
            super(expressionArray, n);
            this.sampleSize = n2;
            this.forUpdate = bl;
        }

        @Override
        protected Value[] fetchNextRow() {
            while ((this.sampleSize <= 0 || this.rowNumber < (long)this.sampleSize) && Select.this.topTableFilter.next()) {
                Select.this.setCurrentRowNumber(this.rowNumber + 1L);
                if (!(this.forUpdate ? Select.this.isConditionMetForUpdate() : Select.this.isConditionMet())) continue;
                ++this.rowNumber;
                Value[] valueArray = new Value[this.columnCount];
                for (int i = 0; i < this.columnCount; ++i) {
                    Expression expression = (Expression)Select.this.expressions.get(i);
                    valueArray[i] = expression.getValue(Select.this.getSession());
                }
                return valueArray;
            }
            return null;
        }

        @Override
        protected boolean skipNextRow() {
            while ((this.sampleSize <= 0 || this.rowNumber < (long)this.sampleSize) && Select.this.topTableFilter.next()) {
                Select.this.setCurrentRowNumber(this.rowNumber + 1L);
                if (!Select.this.isConditionMet()) continue;
                ++this.rowNumber;
                return true;
            }
            return false;
        }
    }

    private abstract class LazyResultSelect
    extends LazyResult {
        long rowNumber;
        int columnCount;

        LazyResultSelect(Expression[] expressionArray, int n) {
            super(expressionArray);
            this.columnCount = n;
            Select.this.setCurrentRowNumber(0L);
        }

        @Override
        public final int getVisibleColumnCount() {
            return Select.this.visibleColumnCount;
        }

        @Override
        public void close() {
            if (!this.isClosed()) {
                super.close();
                Select.this.resetJoinBatchAfterQuery();
            }
        }

        @Override
        public void reset() {
            super.reset();
            Select.this.resetJoinBatchAfterQuery();
            Select.this.topTableFilter.reset();
            Select.this.setCurrentRowNumber(0L);
            this.rowNumber = 0L;
        }
    }
}

